'====================================================================
' AJPapps - Resize pictures to phone
'   2009-2017.  
' 
'             
'   .       
' PNG,          . 
' ?           
'      .    
'    .
' 
'    janGraphics.   
'   AJPapps - Screen grabber.     :
' 
' http://jansfreeware.com/jfobjects.htm
' 
'     CommonFunctions0300.DLL  
'   3.00.0197.     
' ajpMain.LoadPictureExByVar(),     
'  .       
' .
' 
'  "Calc Size Test.VBS"    ,   
'     ^^   
'  ^^
' 
'  7.12.2009
'     ^^
'   
'  3.03.2017
'   [+]     .
'   [+]   Usage.
' 
'====================================================================
'  
' 
' 1.      .
' 2.         .
' 3.          
'     .
' 4.         
'      .
' 5.         , 
'       ,    .
' 6.       .   
'           , 
'         .
' 7.         
'        .
' 8.   ,    ,  
'      lindaoneesama@gmail.com
' 
'   http://purl.oclc.org/Linda_Kaioh/Homepage/
'====================================================================
Option Explicit

Const AppTitle = "AJPapps - Resize pictures to phone"

' Siemens CX75 screen size.
Const PHONE_WIDTH = 176
Const PHONE_HEIGHT = 132

Dim FSO
Dim InDir
Dim OutDir

On Error Resume Next

Set FSO = CreateObject("Scripting.FileSystemObject")
If Err Then
  ErrorMsg "    FileSystemObject."
  WScript.Quit
End If

'  ...
GetArguments InDir, OutDir

' ,    ...
If Not FSO.FolderExists(InDir) Then
  MsgBox InDir & vbCrLf & vbCrLf & _
         "   .", _
         vbCritical, AppTitle
  WScript.Quit
End If

'     ...
MyCreateFolder OutDir
If Err Then
  ErrorMsg OutDir & vbCrLf & vbCrLf & _
           "   -."
  WScript.Quit
End If

'      ...
BrowseTree FSO.GetFolder(InDir), FSO.GetFolder(OutDir)

MsgBox " ^_^v", vbInformation, AppTitle

'====================================================================
Private Sub GetArguments(ByRef InDir, ByRef OutDir)
  If WScript.Arguments.Count = 2 Then
    InDir = WScript.Arguments(0)
    OutDir = WScript.Arguments(1)
  Else
    ShowUsage
    WScript.Quit
  End If
End Sub

Private Sub ShowUsage()
  MsgBox ":" & vbCrLf & vbCrLf & _
         WScript.ScriptName & " InPath OutPath" & vbCrLf & vbCrLf & _
         "InPath -    ." & vbCrLf & vbCrLf & _
         "OutPath - ,     " & _
         ".   .", _
         vbInformation, AppTitle
End Sub

'====================================================================
Private Sub BrowseTree(ByVal InFolder, ByVal OutFolder)
  Dim File
  Dim OutFileName
  Dim InSubFolder
  Dim OutSubFolder
  Dim OutPath
  
  On Error Resume Next
  
  '   ...
  For Each File In InFolder.Files
    OutFileName = FSO.BuildPath(OutFolder.Path, File.Name)
    XCopyFilter File, OutFileName
    
    If Err Then
      ErrorMsg File.Path & vbCrLf & vbCrLf & _
               OutFileName & vbCrLf & vbCrLf & _
               "   ."
      '   ...
      'WScript.Quit
    End If
    Err.Clear
  Next
  
  '   ...
  For Each InSubFolder In InFolder.Subfolders
    OutPath = FSO.BuildPath(OutFolder.Path, InSubFolder.Name)
    
    Set OutSubFolder = MyCreateFolder(OutPath)
    If Err Then
      ErrorMsg OutPath & vbCrLf & vbCrLf & _
               "   ."
      WScript.Quit
    End If
    
    BrowseTree InSubFolder, OutSubFolder
  Next
End Sub

'====================================================================
'     .
'====================================================================
Private Sub ErrorMsg(ByVal Text)
  MsgBox Text & _
         vbCrLf & vbCrlf & _
         "Error " & Err.Number & ": " & Err.Description, _
         vbCritical, AppTitle
End Sub

'====================================================================
'  ,   ,    .  
'  ,    .
'====================================================================
Private Function MyCreateFolder(ByVal Path)
  If FSO.FolderExists(Path) Then
    Set MyCreateFolder = FSO.GetFolder(Path)
  Else
    Set MyCreateFolder = FSO.CreateFolder(Path)
  End If
End Function

'====================================================================
'   ,     ^^
' ,  ,       ^^
'====================================================================
Public Sub XCopyFilter(ByVal InFile, ByVal OutFileName)
  Dim Ext
  Dim Ext2
  Dim TXT
  Dim NewWidth
  Dim NewHeight
  
  Ext = UCase(FSO.GetExtensionName(InFile.Name))
  If Ext <> "JPG" And Ext <> "JPEG" And Ext <> "PNG" And _
     Ext <> "BMP" And Ext <> "GIF" Then Exit Sub
  
  Ext2 = UCase(FSO.GetExtensionName(OutFileName))
  If Len(Ext2) <> 0 Then 
    OutFileName = Left(OutFileName, Len(OutFileName) - Len(Ext2)) & "PNG"
  End If
  
  GetNewSize InFile.Path, NewWidth, NewHeight
  
  On Error Resume Next
  
  TXT = ConvertFile(InFile.Path, OutFileName, NewWidth, NewHeight)
  If TXT <> "" Then Err.Raise 51, , TXT
End Sub

'====================================================================
' 132 x 176
'====================================================================
Private Sub GetNewSize(ByVal InFileName, ByRef NewWidth, ByRef NewHeight)
  Dim ajpMain 'As ajpMain
  Dim Pic 'As StdPicture
  Dim PicInfo 'As PictureInfo
  
  On Error Resume Next
  
  Set ajpMain = CreateObject("CmnFuncs0300.ajpMain")
  Set PicInfo = Nothing
  Set Pic = ajpMain.LoadPictureExByVar(InFileName, PicInfo)
  
  '       .
  If Err.Number = 438 Then
    ErrorMsg " ajpMain.LoadPictureExByVar()  . " & _
             "    CommonFunctions0300.DLL. " & _
             " .    " & _
             "   ."
    WScript.Quit
  End If
  
  On Error Goto 0
  
  ' , ...
  CalcNewSize PHONE_WIDTH, PHONE_HEIGHT, _
              PicInfo.Width, PicInfo.Height, _
              NewWidth, NewHeight, False
End Sub

'====================================================================
Public Sub CalcNewSize(ByVal TargetWidth, ByVal TargetHeight, _
                       ByVal OldWidth, ByVal OldHeight, _
                       ByRef NewWidth, ByRef NewHeight, _
                       ByVal NoRotate)
  '   ...
  If VarType(NoRotate) <> vbBoolean Then NoRotate = False
  
  '    .
  Dim PicRatio
  
  PicRatio = OldWidth / OldHeight
  'WScript.Echo PicRatio
  
  '    ,    
  ' .    ...    -  .
  '        ,   
  '     ...
  Dim Width
  Dim Height
  Dim Flipped ' 
  
  '     ,   
  '  . ,  ,   
  '     ^^
  If PicRatio < 1 And Not NoRotate Then
    Width = OldHeight
    Height = OldWidth
    Flipped = True
  Else
    Width = OldWidth
    Height = OldHeight
    Flipped = False
  End If
  
  '      ...
  Dim PhoneRatio
  
  PhoneRatio = TargetWidth / TargetHeight
  'WScript.Echo PhoneRatio
  
  '      .   
  '      .   
  ' .
  PicRatio = Width / Height
  'WScript.Echo PicRatio
  
  '  .    ...
  If PicRatio = PhoneRatio Then
    NewWidth = TargetWidth
    NewHeight = TargetHeight
  End If
  
  '  .   -   ...
  If PicRatio > PhoneRatio Then
    NewWidth = TargetWidth
    NewHeight = Height / (Width / NewWidth)
  End If
  
  '  ...
  If PicRatio < PhoneRatio Then
    NewHeight = TargetHeight
    NewWidth = Width / (Height / NewHeight)
  End If
  
  '      ^^
  Dim TMP
  
  If Flipped Then
    TMP = NewWidth
    NewWidth = NewHeight
    NewHeight = TMP
  End If
  
  '     Long.    
  '  ....
  NewWidth = CLng(NewWidth)
  NewHeight = CLng(NewHeight)
End Sub

'====================================================================
Function ConvertFile(ByVal FileNameIn, ByVal FileNameOut, _
                     ByVal NewWidth, ByVal NewHeight)
  Dim JG
  
  ConvertFile = "ActiveX can't create object."
  
  Set JG = CreateObject("janGraphics.Compendium")
  'ConvertFile = JG.convert(FileNameBMP, FileNamePNG)
  
  ConvertFile = JG.convertEx(FileNameIn, FileNameOut, _
                             NewWidth, NewHeight, False, 85)
End Function
